/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.Seconds;
import DE.siemens.ad.logo.model.TimeBase;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;
import java.util.Vector;

public class AverageValueParameter
extends Analog {
    private static final long serialVersionUID = -3880612212736531702L;
    private static final transient int AX_MIN_VALUE = Short.MIN_VALUE;
    private static final transient int AX_MAX_VALUE = Short.MAX_VALUE;
    protected static final transient int READY = 0;
    protected static final transient int WAITING = 1;
    protected static final transient int RUNNING = 2;
    public static transient int MAX_TIME_VALUE_DAY = 365;
    public static transient int MAX_TIME_VALUE_HOUR = 23;
    public static transient int MAX_TIME_VALUE_MINITUE = 59;
    public static transient int MAX_TIME_VALUE_SECOND = 59;
    public static transient int MAX_SAMPLE_NUMBER_VALUE_SECOND = 100;
    public static transient int MAX_SAMPLE_NUMBER_VALUE_MINITUE = MAX_SAMPLE_NUMBER_VALUE_SECOND * 60;
    private transient int sum;
    private transient int counter;
    private transient Timer timer;
    private transient int state;
    private TimeBase samplingTime;
    private transient long avgSampleTime;
    private transient long lastCountTime;
    private IntValueProperties sampleNumber = new IntValueProperties();
    private transient Integer averageValue = new Integer(0);
    private transient boolean reachSampleNumber = false;
    private transient long onePeriodTime;
    private transient long lastDisableTime;
    private transient int maxSampleNum;

    public AverageValueParameter() {
        this.samplingTime = new TimeBase(4, 1);
        this.sampleNumber.setErrorKey("error.dialog.invalidValue");
        this.sampleNumber.setDefaultErrorText("Invalid Value");
        this.sampleNumber.setCurrentValue(1);
    }

    public AverageValueParameter(Block block) {
        super(block);
        this.setRemanenceAvailable(true);
        this.samplingTime = new TimeBase(4, 1);
        this.sampleNumber.setErrorKey("error.dialog.invalidValue");
        this.sampleNumber.setDefaultErrorText("Invalid Value");
        this.sampleNumber.setCurrentValue(1);
    }

    public double calculateAnalogValue(double ax, boolean en, boolean rst) {
        if (rst) {
            this.resetParameter();
            this.fCurrentParameterText = this.calculateCurrentParameterText();
            return this.averageValue.intValue();
        }
        if (en) {
            if (this.state == 0) {
                this.state = 2;
                this.getTimer().start();
                this.avgSampleTime = this.convertTimeToMS() / (long)this.sampleNumber.getCurrentValue() / 10L;
            }
            if (this.state == 1) {
                this.state = 2;
                this.getTimer().start();
            }
            if (this.state == 2) {
                this.onePeriodTime = this.lastDisableTime + (long)this.getTimer().getPassedTimeUnitValue();
                if (this.onePeriodTime - this.lastCountTime >= this.avgSampleTime) {
                    this.lastCountTime = this.onePeriodTime;
                    this.fAmplifiedX = this.fMeasurement.getAmplifiedValue((int)ax);
                    ++this.counter;
                    this.sum += this.fAmplifiedX;
                    this.reachSampleNumber = false;
                }
                if (this.counter == this.sampleNumber.getCurrentValue()) {
                    this.averageValue = Math.round(this.sum / this.sampleNumber.getCurrentValue());
                    this.reachSampleNumber = true;
                    this.sum = 0;
                    this.counter = 0;
                    this.lastCountTime = 0L;
                    this.onePeriodTime = 0L;
                    this.lastDisableTime = 0L;
                    this.state = 0;
                    this.getTimer().finish();
                }
            }
        } else if (this.state == 2) {
            this.lastDisableTime = this.onePeriodTime;
            this.state = 1;
            this.getTimer().finish();
        }
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        return this.averageValue.intValue();
    }

    private long convertTimeToMS() {
        int sampleTime = this.samplingTime.getTime();
        long sampleTimeInMS = 0L;
        switch (this.samplingTime.getTimeBaseKey()) {
            case 4: {
                sampleTimeInMS = sampleTime * 24 * 60 * 60 * 1000;
                break;
            }
            case 3: {
                sampleTimeInMS = sampleTime * 60 * 60 * 1000;
                break;
            }
            case 2: {
                sampleTimeInMS = sampleTime * 60 * 1000;
                break;
            }
            case 1: {
                sampleTimeInMS = sampleTime * 1000;
                break;
            }
        }
        return sampleTimeInMS;
    }

    public int calculateMaxSampleNum(int timebase, int timeVal) {
        this.maxSampleNum = 0;
        switch (timebase) {
            case 4: {
                this.maxSampleNum = Short.MAX_VALUE;
                break;
            }
            case 3: {
                this.maxSampleNum = Short.MAX_VALUE;
                break;
            }
            case 2: {
                if (timeVal * MAX_SAMPLE_NUMBER_VALUE_MINITUE >= Short.MAX_VALUE) {
                    this.maxSampleNum = Short.MAX_VALUE;
                    break;
                }
                this.maxSampleNum = timeVal * MAX_SAMPLE_NUMBER_VALUE_MINITUE;
                break;
            }
            case 1: {
                this.maxSampleNum = timeVal * MAX_SAMPLE_NUMBER_VALUE_SECOND;
                break;
            }
        }
        this.sampleNumber.setInc(1);
        this.sampleNumber.setMin(1);
        this.sampleNumber.setMax(this.maxSampleNum);
        return this.maxSampleNum;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence() || forceReset) {
            this.averageValue = 0;
            this.sum = 0;
            this.counter = 0;
            this.state = 0;
            this.lastCountTime = 0L;
            this.getTimer().init(interpreter);
            this.getTimer().finish();
        }
    }

    public AnalogValueProperties getAmplifiedXProperties() {
        if (this.fAmplifiedXProperties == null) {
            this.fAmplifiedXProperties = new AnalogValueProperties(Short.MIN_VALUE, Short.MAX_VALUE, 1, this.fAmplifiedX, this.getDecimalPlace(), this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid Value");
        }
        this.fAmplifiedXProperties.setCurrentValue(this.fAmplifiedX);
        this.fAmplifiedXProperties.setDecimalPlace(this.getDecimalPlace());
        return this.fAmplifiedXProperties;
    }

    public String getParameterText() {
        StringBuffer result = new StringBuffer();
        String remText = super.getParameterText();
        if (remText.length() > 0) {
            result.append(remText);
            result.append("\n");
        }
        result.append("ST = ");
        result.append(this.samplingTime.getTime() + this.samplingTime.getTimeBaseAbbreviation());
        result.append("\n");
        result.append("SN = ");
        result.append(this.sampleNumber);
        return result.toString();
    }

    public String calculateCurrentParameterText() {
        StringBuffer result = new StringBuffer();
        if (this.reachSampleNumber) {
            result.append(Util.addTrailingSpaces(Integer.toString(this.sampleNumber.getCurrentValue()), 5));
        } else {
            result.append(Util.addTrailingSpaces(Integer.toString(this.counter), 5));
        }
        result.append("\n");
        result.append(Util.addTrailingSpaces(Integer.toString(this.averageValue), 5));
        this.fireParameterUpdateEvent();
        return result.toString();
    }

    public void resetParameter() {
        this.sum = 0;
        this.counter = 0;
        this.averageValue = 0;
        this.avgSampleTime = 0L;
        this.state = 0;
        this.lastCountTime = 0L;
        this.onePeriodTime = 0L;
        this.lastDisableTime = 0L;
        this.reachSampleNumber = false;
        this.getTimer().finish();
    }

    public IntValueProperties getSampleNumber() {
        return this.sampleNumber;
    }

    public void setSampleNumber(IntValueProperties sampleNumber) {
        this.sampleNumber = sampleNumber;
    }

    public TimeBase getSamplingTime() {
        return this.samplingTime;
    }

    public void setSamplingTime(TimeBase selTimeBase) {
        this.samplingTime = selTimeBase;
    }

    public Integer getAverageValue() {
        if (this.averageValue == null) {
            this.averageValue = new Integer(0);
        }
        return this.averageValue;
    }

    public void setAverageValue(Integer averageValue) {
        this.averageValue = averageValue;
    }

    public static TimeBase[] getAvailableTimeBases() {
        return new TimeBase[]{new TimeBase(4), new TimeBase(3), new TimeBase(2), new TimeBase(1)};
    }

    public void setTimer(Timer newTimer) {
        this.timer = newTimer;
    }

    public Timer getTimer() {
        if (this.timer == null) {
            this.setTimer(new Timer(new Seconds()));
            this.timer.getParamTime().setMilliseconds(Long.MAX_VALUE);
        }
        return this.timer;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.samplingTime.read(dr);
        if (this.sampleNumber == null) {
            this.sampleNumber = new IntValueProperties();
        }
        this.sampleNumber.setCurrentValue(dr.readInt());
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        this.getSamplingTime().write(dw);
        dw.writeInt(this.getSampleNumber().getCurrentValue());
    }

    public int getTimeBase() {
        return this.getSamplingTime().getTimeBaseKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireParameterSetEvent(String message) {
        this.resetParameter();
        if (!this.getParameterSetListeners().isEmpty()) {
            Vector l;
            AverageValueParameter averageValueParameter = this;
            synchronized (averageValueParameter) {
                l = (Vector)this.fParameterSetListeners.clone();
            }
            for (int i = 0; i < l.size(); ++i) {
                ParameterSetListener pul = (ParameterSetListener)l.elementAt(i);
                pul.parameterSet(this, message);
            }
        }
    }
}

